#ifndef GC_H
#define GC_H

#include <stddef.h>
#include <stdint.h>

#define GC_SIGNEDWORD GC_intptr_t
#define GC_UNSIGNEDWORD GC_uintptr_t
#define GC_word GC_UNSIGNEDWORD

extern void GC_INIT(void);
extern void GC_init(void);
extern void *GC_MALLOC(size_t);
extern void *GC_malloc(size_t);
extern void *GC_MALLOC_ATOMIC(size_t);
extern void *GC_malloc_atomic(size_t);
extern void *GC_REALLOC(void *,size_t);
extern void GC_FREE(void *);
extern void GC_free(void *);

typedef void *(*GC_oom_func)(size_t);
extern GC_oom_func GC_oom_fn;
void GC_set_oom_fn(GC_oom_func);
GC_oom_func GC_get_oom_fn(void);

typedef uintptr_t GC_uintptr_t;
typedef void (*GC_warn_proc)(const char *,GC_uintptr_t);
extern GC_warn_proc GC_set_warn_proc(GC_warn_proc);

#endif
