#include <stdlib.h>
#include "gc.h"

GC_oom_func GC_oom_fn;

void GC_set_oom_fn(GC_oom_func p)
{
  GC_oom_fn = p;
}

GC_oom_func GC_get_oom_fn(void)
{
  return GC_oom_fn;
}

void GC_INIT(void)
{
}

void GC_init(void)
{
}

void *GC_malloc(size_t len)
{
  void *result = malloc(len);
  if (!result) result = GC_oom_fn(len);
  return result;
}

void *GC_malloc_atomic(size_t len)
{
  return GC_malloc(len);
}

void *GC_MALLOC(size_t len)
{
  return GC_malloc(len);
}

void *GC_MALLOC_ATOMIC(size_t len)
{
  return GC_malloc(len);
}

void *GC_REALLOC(void *old,size_t len)
{
  void *result = realloc(old,len);
  if (!result) abort();
  return result;
}

void GC_FREE(void *old)
{
  free(old);
}

void GC_free(void *old)
{
  free(old);
}

GC_warn_proc GC_set_warn_proc(GC_warn_proc p)
{
  return 0;
}
